package com.hero.util;

import java.io.IOException;

import com.hero.HeroDesigner;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class BrowserControl {
	// Used to identify the windows platform.
	private static final String WIN_ID = "Windows";

	// The default system browser under windows.
	private static final String WIN_PATH = "rundll32";

	// The flag to display a url.
	private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

	// The default browser under unix.
	private static final String UNIX_PATH = "netscape";

	// The flag to display a url.

	/**
	 * Display a file in the system browser. If you want to display a file, you
	 * must include the absolute path name.
	 * 
	 * @param url
	 *            the file's url (the url must start with either "http://" or
	 *            "file://").
	 */
	public static void displayURL(String url) {
		final String uri = url;
		Thread runner = new Thread(new Runnable() {
			public void run() {
				boolean windows = BrowserControl.isWindowsPlatform();
				String cmd = null;
				try {
					if ((HeroDesigner.getInstance().getPrefs()
							.getBrowserExecutablePath() != null)
							&& (HeroDesigner.getInstance().getPrefs()
									.getBrowserExecutablePath().trim().length() > 0)) {
						cmd = HeroDesigner.getInstance().getPrefs()
								.getBrowserExecutablePath().trim()
								+ " " + uri;
						Runtime.getRuntime().exec(cmd);
					} else if (windows) {
						// cmd = 'rundll32 url.dll,FileProtocolHandler
						// http://...'
						cmd = BrowserControl.WIN_PATH + " "
								+ BrowserControl.WIN_FLAG + " " + uri;
						Runtime.getRuntime().exec(cmd);
					} else if (HeroDesigner.macOSX) {
						cmd = "open " + uri.replaceAll(" ", "%20");
						Runtime.getRuntime().exec(cmd);
					} else {
						// Under Unix, Netscape has to be running for the
						// "-remote"
						// command to work. So, we try sending the command and
						// check for an exit value. If the exit command is 0,
						// it worked, otherwise we need to start the browser.
						// cmd = 'netscape -remote
						// openURL(http://www.javaworld.com)'
						cmd = "mozilla " + uri;
						Process p = Runtime.getRuntime().exec(cmd);
						try {
							// wait for exit code -- if it's 0, command worked,
							// otherwise we need to start the browser up.
							int exitCode = p.waitFor();
							if (exitCode != 0) {
								// Command failed, start up the browser
								// cmd = 'netscape http://www.javaworld.com'
								cmd = BrowserControl.UNIX_PATH + " " + uri;
								p = Runtime.getRuntime().exec(cmd);
							}
						} catch (InterruptedException x) {
							System.err
									.println("Error bringing up browser, cmd='"
											+ cmd + "'");
							System.err.println("Caught: " + x);
						}
					}
				} catch (IOException x) {
					// couldn't exec browser
					System.err.println("Could not invoke browser, command="
							+ cmd);
					System.err.println("Caught: " + x);
				}
			}
		});
		runner.start();
	}

	/**
	 * Try to determine whether this application is running under Windows or
	 * some other platform by examing the "os.name" property.
	 * 
	 * @return true if this application is running under a Windows OS
	 */
	public static boolean isWindowsPlatform() {
		String os = System.getProperty("os.name");
		if ((os != null) && os.startsWith(BrowserControl.WIN_ID)) {
			return true;
		} else {
			return false;
		}

	}

	/**
	 * Simple example.
	 */
	public static void main(String[] args) {
		BrowserControl.displayURL("http://www.javaworld.com");
	}
}
